/*
 * Decompiled with CFR 0.152.
 */
package com.smart.io;

import android.util.Log;
import com.smart.io.PortManager;
import com.smart.io.WriterResult;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class EthernetPort
extends PortManager {
    private static final String TAG = EthernetPort.class.getSimpleName();
    private Socket mSocket;
    private InetAddress mInetAddress;
    private String mIp;
    private int mPort;
    private SocketAddress mSocketAddress;
    private boolean connSuccessful;
    private boolean connState;

    public EthernetPort(String ip, int port) {
        this.mIp = ip;
        this.mPort = port;
    }

    public EthernetPort() {
    }

    public void setIp(String ip) {
        this.mIp = ip;
    }

    public void setPort(int port) {
        this.mPort = port;
    }

    private void initSocketStream() throws IOException {
        this.inputStream = this.mSocket.getInputStream();
        this.outputStream = this.mSocket.getOutputStream();
    }

    @Override
    public boolean openPort() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                EthernetPort.this.mSocket = new Socket();
                try {
                    EthernetPort.this.mInetAddress = Inet4Address.getByName(EthernetPort.this.mIp);
                    EthernetPort.this.mSocketAddress = new InetSocketAddress(EthernetPort.this.mInetAddress, EthernetPort.this.mPort);
                    EthernetPort.this.mSocket.connect(EthernetPort.this.mSocketAddress, 4000);
                    EthernetPort.this.initSocketStream();
                    EthernetPort.this.connSuccessful = true;
                }
                catch (UnknownHostException e) {
                    Log.e((String)TAG, (String)"IpAddress is invalid", (Throwable)e);
                    EthernetPort.this.connSuccessful = false;
                }
                catch (IOException e) {
                    EthernetPort.this.connSuccessful = false;
                    Log.e((String)TAG, (String)"connect failed", (Throwable)e);
                    try {
                        if (EthernetPort.this.mSocket != null) {
                            EthernetPort.this.mSocket.close();
                        }
                    }
                    catch (IOException e1) {
                        Log.e((String)TAG, (String)"unable to close() socket during connection failure", (Throwable)e1);
                    }
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.connSuccessful;
    }

    @Override
    public boolean isConnect() {
        try {
            return this.mSocket != null && !this.mSocket.isClosed() && this.mSocket.getInputStream() != null && this.mSocket.getOutputStream() != null;
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return false;
        }
    }

    @Override
    public void writeDataImmediately(Vector<Byte> data) throws IOException {
        this.writeDataImmediately(data, 0, data.size());
    }

    @Override
    public void writeDataImmediately(Vector<Byte> data, int offset, int len) throws IOException {
        if (data == null || data.size() <= 0) {
            throw new IllegalArgumentException("Data is empty or size is 0.");
        }
        if (this.mSocket != null && this.outputStream != null) {
            this.outputStream.write(this.convertVectorByteToBytes(data), offset, len);
            this.outputStream.flush();
        }
    }

    @Override
    public void writeDataImadiately(Vector<Byte> data, int offset, int len, long timeout, WriterResult error) {
        if (data == null || data.size() <= 0) {
            error.error(-3);
        }
        try {
            if (this.mSocket != null && this.outputStream != null) {
                if (data != null && data.size() > 0) {
                    this.outputStream.write(this.convertVectorByteToBytes(data), offset, len);
                    this.outputStream.flush();
                }
            } else {
                error.error(-2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            error.error(-1);
        }
    }

    @Override
    public void writeDataImadiately(byte[] data) throws IOException {
    }

    @Override
    public boolean readData(byte[] bytes, int len, long timeout) throws IOException {
        if (this.inputStream == null) {
            return false;
        }
        int i = 0;
        while ((long)i < timeout / 5L) {
            if (this.inputStream.available() == len) {
                this.inputStream.read(bytes, 0, len);
                return true;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean closePort() {
        try {
            this.closeStreamAndSocket();
            return true;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Close port error!", (Throwable)e);
            return false;
        }
    }

    private void closeStreamAndSocket() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        if (this.mSocket != null) {
            this.mSocket.close();
            this.mSocket = null;
        }
    }
}

